define("core_form/submit",["exports","core_form/events"],(function(_exports,_events){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0;
/**
   * Submit button JavaScript. All submit buttons will be automatically disabled once the form is
   * submitted, unless that submission results in an error/cancelling the submit.
   *
   * @module core_form/submit
   * @copyright 2019 The Open University
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @since 3.8
   */
let cookieListener=0;const cookieListeningButtons=[];let currentUploadCount=0;const uploadListeningButtons=[];let uploadListenersRegistered=!1;const getCookieName=()=>"moodledownload_"+M.cfg.sesskey,clearDownloadCookie=()=>{document.cookie=encodeURIComponent(getCookieName())+"=deleted; expires="+new Date(0).toUTCString()},checkUploadCount=()=>{currentUploadCount?uploadListeningButtons.forEach((button=>{button.disabled=!0})):uploadListeningButtons.forEach((button=>{button.disabled=!1}))};_exports.init=elementId=>{const button=document.getElementById(elementId);null!==button&&(button.disabled||uploadListeningButtons.push(button),uploadListenersRegistered||(document.addEventListener(_events.eventTypes.uploadStarted,(()=>{currentUploadCount++,checkUploadCount()})),document.addEventListener(_events.eventTypes.uploadCompleted,(()=>{currentUploadCount--,checkUploadCount()})),uploadListenersRegistered=!0),"off"!==button.form.dataset.doubleSubmitProtection&&button.form.addEventListener("submit",(function(event){const disableAction=function(){event.defaultPrevented||button.disabled||(button.disabled=!0,clearDownloadCookie(),(button=>{cookieListeningButtons.push(button),cookieListener||(cookieListener=setInterval((()=>{2==document.cookie.split(getCookieName()+"=").length&&(clearDownloadCookie(),clearInterval(cookieListener),cookieListener=0,cookieListeningButtons.forEach((button=>{button.disabled=!1})))}),500))})(button))};window.addEventListener("beforeunload",disableAction),setTimeout((function(){window.removeEventListener("beforeunload",disableAction)}),1)}),!1))}}));

//# sourceMappingURL=submit.min.js.map